<?php

namespace App\Http\Controllers;

use App\Payment;
use App\Order;
use Illuminate\Http\Request;

use App\Http\Controllers\epayco\Epayco;
use App\Http\Controllers\epayco\Client;
use App\Http\Controllers\epayco\Utils\PaycoAes;
use DB;

class PaymentController extends Controller
{
    private $epayco, $tokens;

    public function __construct()
    {
        //$this->epayco = new Epayco(array(
        //    "apiKey" => config('services.epayco.public_key'),
        //    "privateKey" => config('services.epayco.private_key'),
        //    "lenguage" => "ES",
        //    "test" => config('services.epayco.test')
        //));
        //$this->tokens = '';
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $payments = DB::table('payment_methods')->get();
        return response()->json(['data' => $payments]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Payment  $payment
     * @return \Illuminate\Http\Response
     */
    public function show(Payment $payment)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Payment  $payment
     * @return \Illuminate\Http\Response
     */
    public function edit(Payment $payment)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Payment  $payment
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Payment $payment)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Payment  $payment
     * @return \Illuminate\Http\Response
     */
    public function destroy(Payment $payment)
    {
        //
    }

    public function generate(Request $request)
    {
        $data = $this->epayco->token->create(array(
            "card[number]" => $request->number,
            "card[exp_year]" => $request->year,
            "card[exp_month]" => $request->month,
            "card[cvc]" => $request->cvc
        ));

        return response()->json($data);
    }
    public function generateCustomer(Request $request)
    {
        $customer = $this->epayco->customer->create(array(
            'token_card' => $request->token,
            "name" => $request->billing['first_name'],
            "email" => $request->billing['email'],
            "default" => true,
            "city" => $request->billing['city'],
            "address" => $request->billing['address'],
            "phone" => $request->billing['phone'],
            "cell_phone" => $request->billing['phone']
        ));
        return response()->json($customer);
    }

    public function pay(Request $request)
    {

        $pay = $this->epayco->charge->create(array(
            "token_card" => $request->token,
            "name" => $request->billing['first_name'],
            "last_name" => $request->billing['last_name'],
            "customer_id" => $request->customer,
            "doc_type" => "CC",
            "doc_number" => $request->dni,
            "email" => $request->billing['email'],
            "bill" => $request->reference,
            "description" => "Pago de la orden: " . $request->reference,
            "value" => $request->value,
            "tax" => "0",
            "tax_base" => "0",
            "currency" => "COP",
            "dues" => "12",
            "address" => $request->billing['address'],
            "phone" => $request->billing['phone'],
            "cell_phone" => $request->billing['phone'],
            "url_response" => 'https://onexfy.com/back/public/api/v2/card/response',
            "url_confirmation" => 'https://onexfy.com/back/public/api/v2/card/confirmation'
        ));
        return response()->json($pay);
    }

    // list bank
    public function getsPseBank()
    {
        $banks = $this->epayco->bank->pseBank();
        return response()->json($banks);
    }

    //pse payment
    public function payPse(Request $request)
    {
        $pse = $this->epayco->bank->create(array(
            "bank" => $request->bank,
            "invoice" => $request->reference,
            "description" => "Pago recarga con la referencia: " . $request->reference,
            "value" => $request->value,
            "tax" => "0",
            "tax_base" => "0",
            "currency" => "COP",
            "type_person" => "0",
            "doc_type" => $request->doc_type,
            "doc_number" => $request->doc_number,
            "name" => $request->name,
            "last_name" => $request->last_name,
            "email" => $request->email,
            "country" => "CO",
            "cell_phone" => $request->phone,
            "url_response" => "https://onexfy.com/back/public/api/v2/response",
            "url_confirmation" => "https://onexfy.com/back/public/api/v2/card/confirmation",
            "method_confirmation" => "POST",
            'ip' => $request->ip,
        ));
        return response()->json($pse);
    }
}
