<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Services\PaymentMethod\PaymentMethodService;
use Illuminate\Http\Request;
use App\Helpers\Helper;

class PaymentMethodController extends Controller
{
    protected $paymentMethodService;

    public function __construct(PaymentMethodService $paymentMethodService)
    {
        $this->paymentMethodService = $paymentMethodService;
    }

    public function index()
    {
        try {
            $paymentMethods = $this->paymentMethodService->getAllPaymentMethods();
            return response()->json($paymentMethods);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function store(Request $request)
    {
        try {
            $data = $request->validate([
                'description' => 'required|string|max:255',
            ]);

            $paymentMethod = $this->paymentMethodService->createPaymentMethod($data);
            return response()->json($paymentMethod, 201);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function show($id)
    {
        try {
            $paymentMethod = $this->paymentMethodService->getPaymentMethodById($id);
            if ($paymentMethod) {
                return response()->json($paymentMethod);
            }
            return response()->json(['message' => 'Payment method not found'], 404);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $data = $request->validate([
                'description' => 'sometimes|string|max:255',
            ]);

            $paymentMethod = $this->paymentMethodService->updatePaymentMethod($id, $data);
            if ($paymentMethod) {
                return response()->json($paymentMethod);
            }
            return response()->json(['message' => 'Payment method not found'], 404);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function destroy($id)
    {
        try {
            $result = $this->paymentMethodService->deletePaymentMethod($id);
            if ($result) {
                return response()->json(['message' => 'Payment method deleted']);
            }
            return response()->json(['message' => 'Payment method not found'], 404);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }
}
