<?php

namespace App\Http\Middleware;

use Closure;
use App\Traits\ApiResponser;

class PermissionsMiddleware
{
    use ApiResponser;

    protected $roles;

    public function __construct($roles)
    {
        $this->roles = $roles;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $hasPermission = false;
        $permissions = $request->user()->Role->Permissions;
        foreach ($permissions as $key => $permission) {
            if ($permission['slug'] === $this->roles) {
                $hasPermission = true;
                break;
            }
        }
        if (!$hasPermission) {
            return $this->errorResponse(
                'No cuentas con el permiso suficiente para realizar esta acción',
                403,
            );
        }
        return $next($request);
    }
}
