<?php

namespace App\Http\Middleware;

use Closure;
use App\Traits\ApiResponser;

class ValidateUserRole
{
    use ApiResponser;

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param integer $role
     * @return mixed
     */
    public function handle($request, Closure $next, $role)
    {
        if ($request->user()->type != $role)
            return $this->errorResponse('No tienes permiso para procesar esta petición.', 403);
        return $next($request);
    }
}
