<?php

namespace App\Http\Requests\Client;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PostRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|max:70',
            'email' => 'email|max:70',
            'address' => 'max:120|min:1',
            'phone' => 'max:11|min:10',
            // 'dni' => [
            //     'required',
            //     'string',
            //     Rule::unique('clients', 'dni')
            //     ->ignore(optional($this->route('clients'))->id)
            //     ->where(function ($query) {
            //         $query->where('user_id', $this->user()->id);
            //     })
            //     ->ignore($this->id, 'id')
            // ]
        ];
    }
}
