<?php

namespace App\Http\Requests\DispatchRelation;

use Illuminate\Foundation\Http\FormRequest;

class DispatchRelationCloseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "relation" => "required",
            "items" => "required|array"
        ];
    }

    public function messages()
    {
        return [
            "relation.required" => "La relacion de despacho es requerida",
            "items.required" => "Los domicilios para la relacion de cierre son requeridos",
            "items.array" => "items debe ser un arreglo"
        ];
    }
}
