<?php

namespace App\Http\Requests\Sender;

use Illuminate\Foundation\Http\FormRequest;

class LogSenderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = $this->id ?? '';
        $dni = $this->dni ?? '';
        $email = $this->email ?? '';

        return [
            'address' => 'required|max:90',
            'company' => 'required|max:60',
            'dni' => 'required|max:12|unique:log_senders,dni,' . $id,
            'email' => 'required|max:90|email|unique:log_senders,email,' . $id,
            'name' => 'required|max:60',
            'password' => 'required_without:id|min:8|regex:/^(?=.*[a-z])(?=.*[A-Z]).{8,}$/',
            'password_confirmation' => 'required_without:id|regex:/^(?=.*[a-z])(?=.*[A-Z]).{8,}$/|same:password',
            'phone' => 'required|max:15',
            'tax_collection' => 'required'
        ];
    }
}
