<?php

namespace App\Http\Requests\Settlements;

use Illuminate\Foundation\Http\FormRequest;

class GenerateSettlementPDFRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'settlement_id' => 'required|numeric',
            'domicilios' => 'required|array|min:1',
            'domicilios.*.id' => 'required|exists:domicilios,id',
        ];
    }
}
