<?php

namespace App\Http\Resources\Domicilio;

use Illuminate\Http\Resources\Json\JsonResource;

use App\Http\Resources\Domiciliario\DomiciliarioResource;
use App\Http\Resources\DomicilioProduct\DomicilioProductsCollection;
use App\Http\Resources\Status\StatusCollection;
use App\Http\Resources\User\UserResource;
use App\Http\Resources\Seller\SellerResource;
use App\Http\Resources\DomicilioPayment\DomicilioPaymentCollection;
use Illuminate\Support\Arr;
use App\PaymentReceived;
use App\CostCenter;

class DomicilioResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'reference' => $this->reference,
            'observation'  => $this->observation,
            'total'  => $this->total,
            'status'  => $this->status,
            'delivery'  => $this->delivery ? $this->delivery : 0,
            'type'  => $this->type,
            'comprobant' => $this->comprobant,
            'client'  => $this->Client,
            'date'  => $this->created_at->format('d-m-Y'),
            'domiciliario_id'  => $this->domiciliario_id,
            'log_sender_id' => $this->log_sender_id,
            'payment_method_id' => $this->payment_method_id,
            'aditional_payment' => $this->aditional_payment,
            'weight' => $this->weight,
            'products' => $this->Products,
            'city' => $this->City ? $this->City->name : '-',
            'statuses' => $this->statusDomicilio ? $this->statusDomicilio : [],
            'content' => $this->content,
            'location' => $this->location
        ];
    }
}
