<?php

namespace App\Http\Resources\DomicilioProduct;

use Illuminate\Http\Resources\Json\ResourceCollection;
use App\Http\Resources\Product\ProductsResource;
use App\Product;
use App\ProductVariants;
use App\ProductStorage;
use App\ProductVariantStorage;

class DomicilioProductsCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'data' => $this->collection->transform(function ($models){

                if($models->product_variant_id != null){
                    $stock = ProductVariantStorage::where('storage_id', $models->selected_store)->where('product_variants_id', $models->product_variant_id)->first();
                }else{
                    $stock = ProductStorage::where('storage_id', $models->selected_store)->where('product_id', $models->product_id)->first();
                }

                return [
                    'id' => $models->id,
                    'reference' => $models->reference,
                    'name' => $models->name,
                    'price'  => $models->price,
                    'utilities'  => $models->utilities,
                    'product_id'  => $models->product_id,
                    'product_variant_id'  => $models->product_variant_id,
                    'total'  => $models->total,
                    'subtotal'  => $models->subtotal,
                    'discount'  => $models->discount,
                    'discount_porcent'  => $models->discount_porcent,
                    'old'  => true,
                    'newProduct'  => 0,
                    'quantity'  => $models->quantity,
                    'taxt'  => $models->taxt,
                    'tax_total'  => $models->tax_total,
                    'selectedStorage' => $models->selected_store,
                    'selected_store'  => $models->selected_store,
                    'product' => $models->product ? $models->product : [],
                    'unit_of_measurement' => isset($models->product->unit_of_measurement) ? $models->product->unit_of_measurement : 'Und',
                    'stock_quantity' => $stock->quantity+$models->quantity,
                    'is_devolution' => false,
                    'quantity_remove' => $models->quantity >= 1 ? 1 : $models->quantity,
                    'variant' => $models->product_variant_id ? ProductVariants::find($models->product_variant_id)->attribute : ''
                ];
            })
        ];
    }
}
