<?php

namespace App\Http\Resources\OpenRegister;

use Illuminate\Http\Resources\Json\ResourceCollection;

class OpenRegisterCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            return [
                'id' => $models->id,
                'date' => $models->date,
                'start_hour' => $models->start_hour,
                'end_hour' => $models->end_hour,
                'init_balance' => $models->init_balance,
                'status' => $models->status,
                'user' => $models->UserOpen ? $models->UserOpen->name : '-',
                'user_id' => $models->user_id,
                'storage' => $models->Storage ? $models->Storage->description : '-',
                'storage_id' => $models->storage_id,
                'Bank' => $models->Bank ? $models->Bank->name : '-',
                'bank_id' => $models->bank_id
            ];
        });
    }
}
