<?php

namespace App\Http\Resources\PhisicalCounting;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\PhisicalCounting\ProductsCollection;

class PhisicalCountingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'date' => $this->created_at->format('d-m-Y'),
            'number' => $this->number,
            'products' => new ProductsCollection($this->products)
        ];
    }
}
