<?php

namespace App\Http\Resources\Pod;

use Illuminate\Http\Resources\Json\ResourceCollection;

use App\Http\Resources\Client\ClientResource;

class PodReportCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            return [
                'id' => $models->id,
                'reference' => $models->reference,
                'price'  => $models->total,
                'total'  => $models->total,
                'client_id' => $models->client_id,
                'utilities'  => $models->utilities,
                'is_pay'  => 'Si',
                'delivery'  => $models->delivery,
                'effecty'  => $models->effecty,
                'debit'  => $models->debit,
                'invoice_url'  => $models->invoice_url,
                'invoice_number'  => $models->invoice_number,
                'discount'  => $models->discount,
                'totalDiscount'  => $models->totalDiscount,
                'subtotal'  => $models->subtotal,
                'credit'  => $models->credit,
                'credit_apply'  => $models->credit_apply,
                'turned'  => $models->turned,
                'transfer'  => $models->transfer,
                'type_payment'  => $models->type_payment,
                'hora'  => $models->created_at,
                'type'  => 3,
                'created_at'  => $models->created_at,
                'seller'  => $models->Seller ? $models->Seller->name : 'Sin vendedor',
                'credit'  => $models->is_credit ? 'Si' : 'No',
                'status' => 10,
                'returns'  => count($models->Returns),
                'client' => new ClientResource($models->Client),
                'storage_id'=> $models->storage_id,
                'creditTotal' => $models->totalCredit(),
                'taxt' => $models->taxt,
                'remaining'  => $models->remaining,
                'tax_total' => $models->tax_total,
                'total_payment' => $models->total_payment != null ? $models->total_payment:'0',
                'observation' => $models->observation,
                'seller_id' => $models->seller_id,
                'user_id' => $models->user_id,
                'reference' => $models->reference,
                'pay_total' => $models->pay_total,
                'price_general' => $models->price_general,
                'expiration_date' => $models->expiration_date,
                'open_register_id' => $models->open_register_id,
                'name'  => $models->Client ? $models->Client->name : 'No posee',
                'phone'  => $models->Client ? $models->Client->phone : 'No posee',
                'totalInvoices'=>$models->totalInvoices,
                'subtotalWithOutTax' => $models->getSubtotalWithOutTax(1.19),
                'coste'=>$models->coste,
                'utilityTotal'=>$models->utilityTotal,
                'rentUntillity'=>$models->rentUntillity,
            ];
        });
    }
}
