<?php

namespace App\Http\Resources\Product;

use Illuminate\Http\Resources\Json\ResourceCollection;

class InventoryMovementsCollection extends ResourceCollection
{

    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
                return [
                    'id' => $models->id,
                    'correlative' => $models->correlative,
                    'product_id' => $models->product_id,
                    'type' => $models->type == 'in' ? 'Entrada' : 'Salida',
                    'date_issue' => $models->date_issue,
                    'quantity' => $models->quantity,
                    'document_type' => $models->document_type,
                    'document_id' => $models->document_id,
                    'current_stock' => $models->current_stock,
                    'initial_stock' => $models->initial_stock,
                    'reference' => $models->reference,
                    'storage_id' => $models->storage_id,
                    'variation_id' => $models->variation_id,
                    'user_id' => $models->user_id,
                    'storage' => $models->storage,
                    'product' => $models->product ? $models->product->name : 'Producto eliminado: ' . $models->product_id,
                    'description' => $models->description,
                    'document' => $models->document
                ];
            });
    }
}
