<?php

namespace App\Http\Resources\Product;

use Illuminate\Http\Resources\Json\ResourceCollection;
use App\Http\Resources\Storage\ProductStoragePosCollection;
use App\Http\Resources\Price\ProductPricesPosCollection;
use App\Http\Resources\ProductVariants\ProductVariantsPosCollection;
use App\ProductVariants;
use Log;

class ProductPosCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            $variants = [];
            if (isset($models->variant)) {
                $data = collect($models->variant->toArray());
                $variants = ProductVariants::where('id', $data['id'])->where('user_id', $models->user_id)->get();
            }
            return [
                'name' => $models->name,
                'sku' => $models->sku,
                'slug' => $models->slug,
                'value' => $models->utilities,
                'type' => $models->type,
                'stock_quantity' => $models->stock_quantity,
                'id' => $models->id,
                'storages' => new ProductStoragePosCollection($models->Storages),
                'price' => $models->price,
                'prices' => new ProductPricesPosCollection($models->prices),
                'variants' => count($variants) > 0 ? new ProductVariantsPosCollection($variants) : new ProductVariantsPosCollection($models->ProductVariants),
                'unit_of_measurement' => $models->unit_of_measurement,
                'tax' => $models->tax,
            ];
        });
    }
}
