<?php

namespace App\Http\Resources\Provider;

use Illuminate\Http\Resources\Json\JsonResource;
use App\EconomicActivity;
use App\Http\Resources\BillingProvider\BillingProviderCollection;

class ProviderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        if($this->invoices){

        }

        return [
            'id' => $this->id,
            'name' => $this->name,
            'dni' => $this->dni,
            'phone' => $this->phone,
            'address' => $this->address,
            'city' => $this->city,
            'department' => $this->department,
            'email' => $this->email,
            'manager' => $this->manager,
            'invoices' => $this->Invoices,
            'buyOrders' => $this->BuyOrders,
            'purse' => $this->PurseProvider,
            'gheto' => $this->gheto,
            'economic_activity_id' => EconomicActivity::find($this->economic_activity_id),
            'address_note' => $this->address_note,
            'great_contributor' => $this->great_contributor ? true : false,
            'self_retaining' => $this->self_retaining ? true : false,
            'type_regime' => $this->type_regime,
            'type_person' => $this->type_person,
            'billings' => new BillingProviderCollection($this->BillingProvider),
            
        ];
    }
}


