<?php

namespace App\Http\Resources\PurseUserPayment;

use Illuminate\Http\Resources\Json\ResourceCollection;
use Illuminate\Support\Str;

class PaymentUserPurseCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            $client['name'] = "Sin cliente";
            return [
                'id' => $models->id,
                'client' => $models->Client ? $models->Client :  $client,
                'total' => $models->total,
                'description' => $models->description,
                'storage_id' => $models->storage_id,
                'storage' => $models->Storage ? $models->Storage : 'Sin bodega',
                'date' => $models->created_at->format('Y-m-d'),
                'reference' => $models->reference ? $models->reference : $models->number_pay,
                'type_payment' => $models->type_payment ==  1 ? 'Efectivo' : 'Transferencia',
                'code' => Str::padLeft($models->id, 9, 0),
                'created_at' => $models->created_at,
                'type' => 'abono'
            ];
        });
    }
}
