<?php

namespace App\Http\Resources\Resolution;

use Illuminate\Http\Resources\Json\ResourceCollection;

class ResolutionCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            return [
                'id' => $models->id,
                'date_from' => $models->date_from,
                'date_to' => $models->date_to,
                'prefix' => $models->prefix,
                'from' => $models->from,
                'to' => $models->to,
                'resolution' => $models->resolution,
                'resolution_date' => $models->resolution_date,
                'type_resolution' => $models->type_resolution,
                'counter' => $models->counter,
                'is_general' => $models->is_general ? true: false,
                'is_active' => $models->is_active ? true : false
            ];
        });
    }
}
