<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Traits\ConsumeExternalService;
use Illuminate\Http\Request;
use Carbon\Carbon;

class StatusJobPropagation implements ShouldQueue
{
    use ConsumeExternalService;

    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    private $request, $order, $baseUrl;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($order, Request $request)
    {
        //
        $this->order = $order;
        $this->request = $request;
        $this->baseUrl = config('services.onexfy.api_url');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
        try {
            $params = [
                'id' => $this->order->id,
                'reference' => $this->order->reference,
                'status' => $this->order->status,
                'updated_at' => $this->order->updated_at->format('Y-m-d H:i:s'),
            ];
            $whiteBrandName = config('services.onexfy.app_name');
            $guideRequest = json_decode($this->performanceRequest(
                $this->request,
                'POST',
                "api/guides/integration/{$whiteBrandName}",
                $params
            ));
        } catch (\Exception $e) {
            \Log::error($e->getMessage());
        }
    }
}
