<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class UniquePerUser implements Rule
{
    private $table;

    public function __construct($table)
    {
        $this->table = $table;
    }

    public function passes($attribute, $value)
    {
        if ($value != null) {
            $find = \DB::table($this->table)
                ->where('user_id', auth()->id())
                ->where($attribute, $value)
                ->first();

            return is_null($find);
        }
        return true;
    }

    public function message()
    {
        return 'Existe un registro con esta referencia.';
    }
}
