<?php

namespace App\Services\Client;

use App\Client;
use App\Services\Domicilio\DomicilioServices;
use App\Traits\ApiResponser;
use App\Http\Resources\Client\ClientResource;

/**
 *
 */
class ClientServices
{
    use ApiResponser;

    protected $domicilioServices, $podServices, $returnsServices;

    function __construct(DomicilioServices $domicilioServices)
    {
        $this->domicilioServices = $domicilioServices;
    }

    public function getAllClients(int $perPage, string $search)
    {
        $query = Client::withCount('Domicilios')
            ->when($search, function ($query) use ($search) {
                $query->where(function ($q) use ($search) {
                    $q->where("id", "like", "%{$search}%")
                        ->orWhere("name", "like", "%{$search}%")
                        ->orWhere("dni", "like", "%{$search}%")
                        ->orWhere("phone", "like", "%{$search}%")
                        ->orWhere("email", "like", "%{$search}%");
                });
            })
            ->orderBy('domicilios_count', 'DESC')
            ->orderBy('created_at', 'ASC')
            ->paginate($perPage);

        return ClientResource::collection($query)->response()->getData(true);
    }


    public function getClientList($request)
    {
        $mainId = $request->user()->getIdMain($request->user());
        if ($request->user()->type == 1)
            $clients = Client::orderby('id', 'DESC')->get();
        else
            $clients = Client::Desc()->UserId($mainId)->get();

        return $clients;
    }

    public function registerClient($request)
    {
        $mainId = $request->user()->getIdMain($request->user());
        $client = Client::create(array_merge($request->all(), ['user_id' => $mainId]));
        return $client;
    }

    public function updateClient($request, $client)
    {
        $mainId = $request->user()->getIdMain($request->user());
        $client->update($request->all());

        return $client;
    }

    /*

    public function loadPurse($client)
    {
        $ordersPurse = $this->domicilioServices->getPurse($client);
        $podPurse = $this->podServices->getPurse($client);
        return ($ordersPurse + $podPurse);
    }

    public function credit($client)
    {
        return $this->returnsServices->loadCreditOn($client);
    }


    public function setPaymentInOrder($order, $total, $user)
    {
        try {
            if (get_class($order) == 'App\PodOrder') {

                PodOrderPayments::create(['total' => $total, 'pod_order_id' => $order->id, 'user_id' => $order->User->id, 'is_check' => true]);
                $this->saveBilling($total, $order->Client->id, 'Pago de ' . $total . ', por concepto de abono al pos: ' . $order->reference . ', agregado por el usuario: ' . $user);
            } else {
                DomicilioPayment::create(['total' => $total, 'domicilio_id' => $order->id, 'user_id' => $order->User->id, 'is_check' => true]);
                $this->saveBilling($total, $order->Client->id, 'Pago de ' . $total . ', por concepto de abono al pedido: ' . $order->reference . ', agregado por el usuario: ' . $user);
            }
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

    public function saveBilling($total, $client, $description)
    {
        try {
            Billing::create([
                'total_billing' => $total,
                'description' => $description,
                "type" => 2,
                "operator" => "-",
                "client_id" => $client
            ]);
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    } */
}
