<?php

namespace App\Services\Domicilio;

use App\Services\Settlement\SettlementCalculationService;
use App\Domicilio;

class DomicilioSettlementService
{
    protected $settlementCalculationService;

    public function __construct(SettlementCalculationService $settlementCalculationService)
    {
        $this->settlementCalculationService = $settlementCalculationService;
    }

    public function calculateSettlementByDomicilio($reference)
    {
        $domicilio = Domicilio::where("reference", $reference)->get()->first();

        if (isset($domicilio)) {
            $settlementData = $this->settlementCalculationService->generateDomicilioData($domicilio);
            return $settlementData;
        }

        return null;
    }

    public function isThereDropshipper($reference)
    {
        $domicilio = Domicilio::where("reference", $reference)->get()->first();

        if(!isset($domicilio->dropshipper) || count($domicilio->dropshipper) == 0) {
            return false;
        }

        return true;
    }

    public function calculateComercioSettlement($reference)
    {
        $domicilio = Domicilio::where("reference", $reference)->get()->first();
    }

}
