<?php

namespace App\Services\DomicilioNews;

use DB;
use App\Domicilio;
use App\DomicilioNews;
use App\Traits\ApiResponser;
use App\Services\Domicilio\DomicilioServices;
use App\Enums\NewsConst;
use App\Enums\DomicilioStatusConst;

/**
 *
 */
class DomicilioNewServices
{
    use ApiResponser;

    protected $domicilioServices;

    function __construct(DomicilioServices $domicilioService)
    {
        $this->domicilioServices = $domicilioService;
    }

    /**
     * Create domicilio collection
     * @param array $params
     */
    public function createDomicilioNews(array $params)
    {
        try {
            // create news
            // $domicilioCollection = DomicilioNews::create($params);
            $domicilioCollection = DomicilioNews::create([
                'description' => $params["description"],
                'domicilio_id' => $params["domicilio_id"],
                'new_type_id' => $params["type"]
            ]);

            if (isset($params['file'])) {
                $this->domicilioServices->uploadEvidence(
                    $params['file'],
                    $params['domicilio_id'],
                    'Novedad'
                );
            }
            $domicilio = Domicilio::findOrFail($params['domicilio_id']);
            if ($params["type"] === NewsConst::CANCELLED) {
                $domicilio->update(['status' => DomicilioStatusConst::CANCELED]);
                $this->domicilioServices->setStatuses(
                    array($params['domicilio_id']),
                    DomicilioStatusConst::CANCELED,
                    $domicilioCollection->type ? $domicilioCollection->type : '',
                );
            } else {
                $domicilio->update(['status' => 'Novedad']);
                $this->domicilioServices->setStatuses(
                    array($params['domicilio_id']),
                    'Novedad',
                    $domicilioCollection->type ? $domicilioCollection->type : '',
                );
            }
            return $domicilioCollection;
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

    public function getDomicilioNewById($domicilioId)
    {
        try {
            return DomicilioNews::where("domicilio_id", $domicilioId)->first();
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }
}
