<?php

namespace App\Services\Onexfy;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use App\Services\Domicilio\DomicilioSettlementService;
use App\Enums\DomicilioStatusConst;

class OnexfyService
{
    protected $apiUrl;
    protected $prefix;
    protected $domicilioSettlementService;

    public function __construct(DomicilioSettlementService $domicilioSettlementService)
    {
        $this->domicilioSettlementService = $domicilioSettlementService;
        $this->apiUrl = config('services.onexfy.api_url');
        $this->prefix = env("ONEX_DELIVERY_PREFIX");
    }

    public function notifyChangeStatusOrder($reference, $status, $note)
    {
        $params = [];

        try {
            $settlementData = null;

            if (DomicilioStatusConst::VERIFIED === $status) {
                $settlementData = $this->domicilioSettlementService->calculateSettlementByDomicilio($reference);
            }

            if (is_object($settlementData)) {
                if (!$this->domicilioSettlementService->isThereDropshipper($reference) && DomicilioStatusConst::VERIFIED == $status) {
                    $settlementData->provider_settlement = number_format($settlementData->total, 2);
                }

                $params = [
                    "reference" => $reference,
                    "status" => $status,
                    "note" => $note,
                    "dropshipper_settlement" => $settlementData->dropshipper_settlement ?? 0,
                    "prov_settlement" => $settlementData->provider_settlement ? number_format($settlementData->provider_settlement, 2) : 0
                ];
            } else {
                $params = [
                    "reference" => $reference,
                    "status" => $status,
                    "note" => $note,
                    "dropshipper_settlement" => 0,
                    "prov_settlement" => 0
                ];
            }

            // Verificar los datos que estás enviando antes de la solicitud
            Log::info('Onexfy API Request', [
                'endpoint' => "{$this->apiUrl}/api/v2/update-order-status",
                'params' => $params,
            ]);

            $response = Http::withHeaders([
                'Custom-Auth-Token' => env("CUSTOM_AUTH_TOKEN"), // Asegúrate de que esté cargando correctamente el token
            ])
                ->post("{$this->apiUrl}/api/v2/update-order-status", $params);

            if ($response->successful()) {
                Log::info('Onexfy API Successful Response', [
                    'endpoint' => "{$this->apiUrl}/api/v2/update-order-status",
                    'params' => $params,
                    'response' => $response->json(),
                ]);

                return $response->json();
            }

            return [
                'error' => true,
                'message' => $response->body(),
            ];
        } catch (\Exception $e) {
            Log::critical('Onexfy API Exception', [
                'endpoint' => "{$this->apiUrl}/api/v2/update-order-status",
                'params' => $params,
                'exception' => $e->getMessage(),
            ]);

            return [
                'error' => true,
                'message' => $e->getMessage(),
            ];
        }
    }

    public function createOrderTemp($params)
    {
        try {
            // Verificar los datos que estás enviando antes de la solicitud
            Log::info('TEMPORAL API Request', [
                'endpoint' => "https://delivery.ecomdex.co/api/v2/create/order",
                'params' => $params,
            ]);

            $response = Http::withHeaders([
                'Custom-Auth-Token' => env("CUSTOM_AUTH_TOKEN"), // Asegúrate de que esté cargando correctamente el token
            ])
                ->post("https://delivery.ecomdex.co/api/v2/create/order", $params);

            if ($response->successful()) {
                Log::info('TEMPORAL API Successful Response', [
                    'endpoint' => "https://delivery.ecomdex.co/api/v2/create/order",
                    'params' => $params,
                    'response' => $response->json(),
                ]);

                return $response->json();
            }

            return [
                'error' => true,
                'message' => $response->body(),
            ];
        } catch (\Exception $e) {
            Log::critical('TEMPORAL API Exception', [
                'endpoint' => "https://delivery.ecomdex.co/api/v2/create/order",
                'params' => $params,
                'exception' => $e->getMessage(),
            ]);

            return [
                'error' => true,
                'message' => $e->getMessage(),
            ];
        }
    }
}
