<?php

namespace App\Services\PaymentMethod;

use App\PaymentMethod;
use App\Http\Resources\PaymentMethods\PaymentMethodResource;

class PaymentMethodService
{
    public function getAllPaymentMethods()
    {
        $query = PaymentMethod::orderBy('created_at', 'ASC')
            ->paginate(10);

        return PaymentMethodResource::collection($query)->response()->getData(true);
    }

    public function getPaymentMethodById(int $id): ?PaymentMethod
    {
        return PaymentMethod::find($id);
    }

    public function createPaymentMethod(array $data): PaymentMethod
    {
        return PaymentMethod::create($data);
    }

    public function updatePaymentMethod(int $id, array $data): ?PaymentMethod
    {
        $paymentMethod = PaymentMethod::find($id);
        if ($paymentMethod) {
            $paymentMethod->update($data);
        }
        return $paymentMethod;
    }

    public function deletePaymentMethod(int $id): bool
    {
        $paymentMethod = PaymentMethod::find($id);
        if ($paymentMethod) {
            return $paymentMethod->delete();
        }
        return false;
    }
}
