<?php

namespace App\Services\Status;

use App\Domicilio;
use App\User;
use App\Enums\RolesUserConst;
use App\Enums\DomicilioStatusConst;
use App\Services\Domicilio\DomicilioServices;

class StatusService
{
    protected $domicilioService;

    public function __construct(DomicilioServices $domicilioService)
    {
        $this->domicilioService = $domicilioService;
    }

    public function getStatusList($userId)
    {
        $user = User::findOrFail($userId);

        switch ($user->role_id) {
            case RolesUserConst::REMITTENT:
                return [
                    DomicilioStatusConst::RESCHEDULED,
                ];
            default:
                return [
                    DomicilioStatusConst::ON_THE_WAY,
                    DomicilioStatusConst::IN_WAREHOUSE,
                    DomicilioStatusConst::ON_THE_ROAD,
                    DomicilioStatusConst::PENDING,
                    DomicilioStatusConst::DELIVERED,
                    DomicilioStatusConst::CANCELED,
                    DomicilioStatusConst::NEW_EVENT,
                    DomicilioStatusConst::RETURNED,
                    DomicilioStatusConst::RESCHEDULED,
                    DomicilioStatusConst::SOLUTION,
                    DomicilioStatusConst::REVERSED,
                    DomicilioStatusConst::GENERATED_GUIDE,
                    DomicilioStatusConst::VERIFIED
                ];
        }
    }

    public function verifyDomicilios($items)
    {
        $result = [];

        foreach ($items as $item) {
            $domicilio = Domicilio::findOrFail($item['domicilio_id']);
            $domicilio->status = DomicilioStatusConst::VERIFIED;
            $domicilio->save();
            $result[$domicilio->id] = $domicilio; //PARA RETORNAR
        }

        $domicilios = array_map(function ($item) {
            return Domicilio::findOrFail($item['domicilio_id'])->id;
        }, $items);

        // Usar `setStatuses` con el array mapeado
        $this->domicilioService->setStatuses($domicilios, DomicilioStatusConst::VERIFIED);

        return $result;
    }
}
