<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Status extends Model
{
    //fillable
    protected $fillable = [
        'status',
        'observation',
        'domicilio_id',
        'domiciliario',
        'updated_by'
    ];

    protected static function boot()
    {
        parent::boot();

        // Automatically load the 'user' relationship when querying Status
        static::addGlobalScope('user', function ($query) {
            $query->with('user');
        });
    }

    //relations
    public function domicilio() {
        return $this->belongsTo('App\Domicilio');
    }

    public function user()
    {
        return $this->belongsTo(User::class,"updated_by");
    }
}
