<?php

namespace App\Traits;

use GuzzleHttp\Client;
use Illuminate\Http\Request;

trait ConsumeExternalService
{
    public function performanceRequest(Request $request, $method, $requestUrl, $formParams = [], $headers = [])
    {

        $client = new Client([
            'verify' => false,
        ]);
        $url = $this->baseUrl . '/' . $requestUrl;
        $currentMethod = strtolower($method);
        // * evaluate request method [get, post, put, delete]
        if (
            $currentMethod == 'get'
            || $currentMethod == 'post'
            || $currentMethod == 'put'
        ) {
            $params = null;
            // * get all params by request
            if (count($request->all()) > 0) {
                foreach ($request->all() as $key => $value) {

                    if (!is_array($value)) {
                        $params = $params . $key . '=' . $value . '&';
                    }else{
                        $params = $params . $key . '=' . json_encode($value) . '&';
                    }
                }
            }
            if (count($formParams) > 0 and $currentMethod == 'get') {
                foreach ($formParams as $key => $value) {
                    if (!is_array($value)) {
                        $params = $params . $key . '=' . $value . '&';
                    }else{
                        $params = $params . $key . '=' . json_encode($value) . '&';
                    }
                }
            }
            // * delete the last char in string
            $params = substr($params, 0, -1);
            // * concat params with url
            $url = $url . '?' . $params;
        }
        if ($request->header('subdomain')) {
            $headers['subdomain'] = $request->header('subdomain');
        }
        $response = $client->request($method, $url, [
            'form_params' => $formParams,
            'headers'     => $headers
        ]);
        return $response->getBody()->getContents();

    }

    public function performanceRequestGlobal(Request $request, $method, $requestUrl, $formParams = [], $headers = [])
    {
        $client = new Client(['verify' => false,]);
        $url = $requestUrl;
        $currentMethod = strtolower($method);
        // * evaluate request method [get, post, put, delete]
        if ($currentMethod == 'get' || $currentMethod == 'post' || $currentMethod == 'put') {
            $params = null;
            // * get all params by request
            foreach ($request->all() as $key => $value) {
                if (!is_array($value)) {
                    $params = $params . $key . '=' . $value . '&';
                }
            }
            // * delete the last char in string
            $params = substr($params, 0, -1);
            // * concat params with url
            $url = $url . '?' . $params;
        }
        if ($request->header('subdomain')) {
            $headers['subdomain'] = $request->header('subdomain');
        }
        $response = $client->request($method, $url, [
            'form_params' => $formParams,
            'headers'     => $headers
        ]);
        return $response->getBody()->getContents();
    }
}
