<?php

namespace App\Traits;

trait HasContentCount
{
    public function getContentCountAttribute()
    {
        $content = json_decode($this->content, true);

        if (!is_array($content)) {
            return 0;
        }

        $totalQuantity = 0;

        foreach ($content as $item) {
            if (isset($item['quantity'])) {
                $totalQuantity += (int)$item['quantity'];
            }
        }

        return $totalQuantity;
    }
}
