<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
use App\Http\Resources\Ecommerce\EcommerceResource;

use Laravel\PricingPlans\Contracts\Subscriber;
use Laravel\PricingPlans\Models\Concerns\Subscribable;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Authenticatable implements Subscriber
{
    use HasApiTokens, Notifiable, Subscribable, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'role_id',
        'type',
        'photo',
        'domiciliario_id',
        'woocomerce_url',
        'woocomerce_ck',
        'woocomerce_cs',
        'parent_id',
        'type_person',
        'storage_id',
        'has_woocommerce',
        'log_sender_id'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    //relations of model
    public function Domiciliarios()
    {
        return $this->hasMany('App\Domiciliario');
    }

    public function Domicilios()
    {
        return $this->hasMany('App\Domicilio');
    }

    public function LogSenders()
    {
        return $this->hasMany('App\LogSender', 'user_id');
    }

    public function Configuration()
    {
        return $this->hasMany(Configuration::class, 'user_id');
    }


    public function parent()
    {
        return $this->belongsTo('App\User', 'parent_id');
    }

    public function getIdMain($user)
    {
        if ($user->type == 2) {
            return $user->id;
        }
        if ($user->type == 4) {
            return $user->parent_id;
        }
        if ($user->type == 5) {
            return $user->parent_id;
        }
    }

    public function getOwnUser($user)
    {
        if ($user) {
            $own = User::findOrFail($user);
            $own->brand = new EcommerceResource($own->Ecommerce);
            return $own;
        } else {
            return 'no-parent';
        }
    }

    public function getMainUser()
    {
        if ($this->parent_id)
            return User::find($this->parent_id);
        else
            return $this;
    }

    /**
     * Get the role of every user
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function Role()
    {
        return $this->belongsTo(Role::class);
    }

    // scope local
    public function scopeEmail($query, $email)
    {
        return $query->where('email', $email);
    }

    public function scopeName($query, $name)
    {
        return $query->where('name', $name);
    }

    public function scopeType($query)
    {
        return $query->whereBetween('type', [4, 5]);
    }

    public function scopeDesc($query)
    {
        return $query->orderBy('id', 'DESC');
    }

    public function scopeAsc($query)
    {
        return $query->orderBy('id', 'ASC');
    }

    public function scopeParent($query, $id)
    {
        return $query->where('parent_id', $id);
    }

    public function cities()
    {
        return $this->belongsToMany(City::class, 'coordinator_has_cities', 'user_id', 'city_id');
    }
}
