<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Zone extends Model
{
    //fillable
    protected $fillable = [
        'name',
        'code',
        'city_id',
        'value',
        'finally_price',
    ];

    /**
     * relations
     */
    public function Clients() {
        return $this->hasMany('App\Client', 'zone_id');
    }

    public function city()
    {
        return $this->belongsTo(City::class);
    }
}
