<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
        'endpoint' => env('MAILGUN_ENDPOINT', 'api.mailgun.net'),
    ],

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'dropi' => [
        'base_url' => env('DROPI_URL'),
        'email' => env('DROPI_EMAIL'),
        'password' => env('DROPI_PASSWORD')
    ],

    'epayco' => [
        'p_client' => env('EPAYCO_P_CUST_ID_CLIENTE'),
        'p_key' => env('EPAYCO_P_KEY'),
        'test' => env('EPAYCO_TEST'),
        'public_key' => env('EPAYCO_PUBLIC_KEY'),
        'private_key' => env('EPAYCO_PRIVATE_KEY'),
        'test' => env('EPAYCO_TEST'),
    ],

    'sempli' => [
        'token' => env('SEMPLI_TOKEN'),
        'resolution' => env('SEMPLI_RESOLUTION_TEST'),
        'test' => env('SEMPLI_TEST'),
        'test_url' => env('SEMPLI_TEST_URL'),
        'url' => env('SEMPLI_URL'),
    ],
    'onexfy' => [
        'api_url' => env('APP_ENV') == 'local' ? env('ONEXFY_DEVELOP_URL') :  env('ONEXFY_PRODUCTION_URL'),
        'app_name' => env('APP_NAME')
    ]
];
