<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDomiciliosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('domicilios', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('reference', 60)->unique()->nullable();
            $table->string('channel', 250)->nullable();
            $table->longText('observation')->nullable();
            $table->double('price', 100, 2)->nullable();
            $table->double('delivery', 100, 2)->nullable();
            $table->double('total', 100, 2)->nullable();
            $table->string('aditional_payment')->nullable();
            $table->string('status', 120);
            $table->string('weight', 120);
            $table->unsignedBigInteger('payment_method_id')->nullable()->index('domicilios_payment_method_id_foreign');
            $table->string('type', 60);
            $table->unsignedBigInteger('domiciliario_id')->nullable()->index('domicilios_domiciliario_id_foreign');
            $table->unsignedBigInteger('client_id')->nullable()->index('domicilios_client_id_foreign');
            $table->string('invoice_url', 250)->nullable();
            $table->softDeletes();
            $table->timestamps();
            $table->unsignedBigInteger('log_sender_id')->nullable()->index('domicilios_log_sender_id_foreign');
            $table->string('comprobant', 250)->nullable();
            $table->text("location")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('domicilios');
    }
}
