<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAuditsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('audits', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('user')->nullable();
            $table->longText('observation')->nullable();
            $table->string('entity')->nullable();
            $table->string('date')->nullable();
            $table->string('hour')->nullable();
            $table->timestamps();
            $table->unsignedBigInteger('user_id')->nullable()->index('auditorias_user_id_foreign');
            $table->string('name')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('audits');
    }
}
