<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDomiciliariosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('domiciliarios', function (Blueprint $table) {
            $table->id();
            $table->string('name', 250)->nullable();
            $table->string('dni', 250)->nullable()->unique();
            $table->string('phone', 250)->nullable();
            $table->string('placa', 250)->nullable();
            $table->timestamps();
            $table->string('photo', 250)->default('default-profile');
            $table->string('domiciliario')->nullable();
            $table->string('username')->nullable();
            $table->string('password')->nullable();
            $table->unsignedBigInteger('user_id')->nullable()->index('domiciliarios_user_id_foreign');
            $table->softDeletes();
            $table->string('email')->nullable()->unique();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('domiciliarios');
    }
}
