<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDomicilioCollectionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('domicilio_collections', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->double('value', 50, 2)->nullable();
            $table->string('evidence', 250)->nullable();
            $table->string('payment', 250)->nullable();
            $table->timestamps();
            $table->unsignedBigInteger('domicilio_id')->nullable();
            $table->foreign(['domicilio_id'])->references(['id'])->on('domicilios')->onUpdate('CASCADE')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('domicilio_collections');
    }
}
