<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLogSendersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('log_senders', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('name');
            $table->string('department', 250);
            $table->string('city', 250)->nullable();
            $table->string('section', 250)->nullable();
            $table->string('address', 250);
            $table->string('email');
            $table->timestamps();
            $table->string('dni', 20)->nullable();
            $table->string('phone', 11)->nullable();
            $table->softDeletes();
            $table->string('company')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('log_senders');
    }
}
