<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDomicilioHasSettlementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('domicilio_has_settlements', function (Blueprint $table) {
            $table->id();
            $table->foreignId("domicilio_id")
                ->nullable()
                ->references("id")
                ->on("domicilios")
                ->onUpdate("cascade")
                ->onDelete("cascade");
            $table->foreignId("settlement_id")
                ->nullable()
                ->references("id")
                ->on("settlements")
                ->onUpdate("cascade")
                ->nullOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('domicilio_has_settlements');
    }
}
