<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDropshipperSettlementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dropshipper_settlements', function (Blueprint $table) {
            $table->id();
            $table->foreignId("domicilio_id")
                ->references("id")
                ->on("domicilios")
                ->onUpdate("cascade")
                ->onDelete("cascade");
            $table->string("name_dropshipper");
            $table->float("provider_cost");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dropshipper_settlements');
    }
}
