<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDomiciliarioHasCitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('domiciliario_has_cities', function (Blueprint $table) {
            $table->id();
            $table->foreignId("domiciliario_id")
                ->nullable()
                ->references("id")
                ->on("domiciliarios")
                ->onDelete("cascade")
                ->onUpdate("cascade");

            $table->foreignId("city_id")
                ->nullable()
                ->references("id")
                ->on("cities")
                ->onDelete("cascade")
                ->onUpdate("cascade");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('domiciliario_has_cities');
    }
}
