<!DOCTYPE html>
<html lang="es">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
    	<meta http-equiv="X-UA-Compatible" content="ie=edge">
		<title>Reporte de cierre #{{$relation->id}}</title>
		<style>
			/* Estilos generales */
			@page {
				margin: 1cm;
			}

			body {
				min-width: 100px;
				min-height: 100%;
				font-family: "Work Sans", sans-serif;
				-ms-text-size-adjust: 100%;
				-webkit-text-size-adjust: 100%;
				-webkit-font-smoothing: antialiased;
				-moz-osx-font-smoothing: grayscale;
				font-smoothing: antialiased;
				line-height: 1.5;
				font-size: 14px;
				color: #333;
				background-color: #fff;
			}

			/* Header */
			header {
				position: relative;
                @if (!isset($configuration))
				    background: #9747ff;
                    @else
				    background: {{ $configuration->brand_color }};
                @endif
				margin-top: -1cm;
				margin-left: -40px;
				width: 120%;
				z-index: 1;
			}

			.header-container {
				width: 930px;
				height: 110px;
				@if (!isset($configuration))
				    background: #9747ff;
                    @else
				    background: {{ $configuration->brand_color }};
                @endif
				margin: 0 auto;
				padding: 0 20px;
				z-index: 1;
			}

			.logo {
				width: 190px;
				margin-left: 20px;
				margin-top: 45px;
			}

			.text {
				font-size: 25px;
				font-weight: 600;
				line-height: 29.33px;
				color: white;
				position: absolute;
				top: 45px;
				left: 440px;
			}

			/* Card */
			.card-container {
				position: absolute;
				z-index: 2;
				margin: 0 -5px;
				background-color: #fff;
				width: 715px;
				height: 80px;
				margin-top: -50px;
				margin-lefteft: 34px;
				padding: 6px;
				border-radius: 6px;
				border: 1px #ECECEC solid;
				gap: 20px;
			}

			.card-container:after {
				content: "";
				display: table;
				clear: both;
			}

			.card-content-domiciliary {
				float: left;
				width: 35%;
				padding: 0 18px;
			}

			.card-content {
				float: left;
				width: 25%;
				padding: 0 10px;
			}

			.card {
				box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2);
				padding-top: 12px;
				text-align: left;
				background-color: #ffffff;
			}

			.ico-card {
				width: 40px;
				height: 40px;
				border-radius: 50%;
				@if (!isset($configuration))
				    background: #9747ff;
                    @else
				    background: {{ $configuration->brand_color }};
                @endif
				position: relative;
				margin-left: -5px
			}

			.ico-card img {
				display: block;
				width: 20px;
				height: 20px;
				position: absolute;
				top: 50%;
				left: 50%;
				transform: translate(-50%, -50%);
			}

			.title-card {
				color: #1E1D20;
				font-size: 13px;
				font-weight: 600;
				line-height: 13.65px;
				letter-spacing: 0em;
				text-align: left;
				margin-bottom: 4px;
			}

			.text-card {
				color: #1E1D20;
				font-size: 13px;
				font-weight: 400;
				line-height: 13.65px;
				letter-spacing: 0em;
				text-align: left;
				margin-top: 0;
			}

			.title-card,
			.text-card {
				white-space: nowrap;
				overflow: hidden;
				text-overflow: ellipsis;
			}

			/* Table */
			main {
				margin-top: 0;
				margin-bottom: 1.5cm;
				position: relative;
			}

			table {
				border-spacing: 0;
				border-collapse: collapse;
				background-color: transparent;
			}

			td,
			th {
				padding: 0;
			}

			th {
				text-align: left;
			}

			.table {
				width: 100%;
				max-width: 100%;
				margin-bottom: 20px;
			}

			.table>thead>tr>th,
			.table>tbody>tr>th,
			.table>tfoot>tr>th,
			.table>thead>tr>td,
			.table>tbody>tr>td,
			.table>tfoot>tr>td {
				padding: 0px;
				line-height: 1.02857143;
				vertical-align: top;
			}

			.table>thead>tr>th {
				vertical-align: bottom;
			}

			.table>caption+thead>tr:first-child>th,
			.table>colgroup+thead>tr:first-child>th,
			.table>thead:first-child>tr:first-child>th,
			.table>caption+thead>tr:first-child>td,
			.table>colgroup+thead>tr:first-child>td,
			.table>thead:first-child>tr:first-child>td {
				border-top: 0;
			}

			.table>tbody+tbody {}

			.table .table {
				background-color: #ffffff;
			}

			.table-condensed>thead>tr>th,
			.table-condensed>tbody>tr>th,
			.table-condensed>tfoot>tr>th,
			.table-condensed>thead>tr>td,
			.table-condensed>tbody>tr>td,
			.table-condensed>tfoot>tr>td {
				padding: 0px;
			}

			.table-bordered {
				border: 1px solid #ECECEC;
			}

			.table-bordered>thead>tr>th,
			.table-bordered>tbody>tr>th,
			.table-bordered>tfoot>tr>th,
			.table-bordered>thead>tr>td,
			.table-bordered>tbody>tr>td,
			.table-bordered>tfoot>tr>td {
				border: 1px solid #ECECEC;
			}

			.table-bordered>thead>tr>th,
			.table-bordered>thead>tr>td {
				border-bottom-width: 2px;
			}

			.table-striped>tbody>tr:nth-of-type(odd) {
                opacity: 0.4;
                border-radius: 4px;
                @if (!isset($configuration))
                    background-color: rgba(151, 71, 255, 0.4); /* Color de fondo predeterminado con opacidad al 40% */
                    @else
                    background-color: rgba(169, 169, 169, 0.4);
                @endif
			}

			table col[class*="col-"] {
				position: static;
				display: table-column;
				float: none;
			}

			table td[class*="col-"],
			table th[class*="col-"] {
				position: static;
				display: table-cell;
				float: none;
			}

			.collapse {
				display: none;
			}

			.collapse.in {
				display: block;
			}

			tr.collapse.in {
				display: table-row;
			}

			tbody.collapse.in {
				display: table-row-group;
			}

			.table-content {
				margin-top: 3rem;
				margin-left: 0px;
				border-top: 1px solid #ECECEC;
				padding-top: 20px;
				padding-bottom: 10px;
			}

			.table-label {
				font-size: 12px;
				font-weight: 600;
				line-height: 13.65px;
				letter-spacing: 0em;
				text-align: left;
				color: #A1A1A1;
				padding-left: 10px;
			}

			.table-text {
				font-weight: 400;
				line-height: 13.65px;
				letter-spacing: 0em;
				text-align: left;
				padding-left: 10px;
			}

			td.reference,
			td.phone,
			td.name {
				width: 120px;
			}

			td.total {
				padding-right: 10px !important;
			}

			td.reference,
			td.name,
			td.address,
			td.phone,
			td.total {
				vertical-align: middle !important;
			}

			.table-total-container {
				width: 715px;
				height: 86px;
				top: 596px;
				left: 20px;
				padding: 26px, 16px, 26px, 16px;
				border: 1px, 0px, 0px, 0px;
				justify: space-between;
				background-color: #F6F6F6;
			}

            .table-total-payment-methods {
				width: 715px;
				top: 596px;
				left: 20px;
				padding: 26px, 16px, 26px, 16px;
				border: 1px, 0px, 0px, 0px;
				justify: space-between;
				background-color: #F6F6F6;
                margin-bottom: 1rem;
			}

			.table-cant-content {
				float: left;
				margin-top: 0;
				font-size: 13px;
				font-weight: 600;
				letter-spacing: 0em;
				text-align: left;
				color: #1E1D20;
				padding-left: 20px;
			}

			.table-cant-label {
				margin-top: 0;
				font-size: 13px;
				font-weight: 600;
				letter-spacing: 0em;
				text-align: left;
				color: #1E1D20;
			}

			.table-cant-text {
				margin-top: 0;
				font-size: 23px;
				font-weight: 600;
				line-height: 27px;
				letter-spacing: 0em;
				text-align: left;
                @if (!isset($configuration))
                    color: #9747ff;
                    @else
				    color: {{ $configuration->brand_color }};
                @endif
			}

			.table-total-content {
				float: right;
				padding-right: 20px;
			}

			.table-total-label {
				margin-top: 0;
				font-size: 13px;
				font-weight: 600;
				letter-spacing:
				0em; text-align: left;
				color: #1E1D20;
				padding-left: 10px;
			}

			.table-total-text {
				margin-top: 0;
				font-size: 23px;
				font-weight: 600;
				line-height: 27px;
				letter-spacing: 0em;
				text-align: left;
				@if (!isset($configuration))
                    color: #9747ff;
                    @else
				    color: {{ $configuration->brand_color }};
                @endif
			}

			/* Footer */
			footer {
				position: relative;
				bottom: 0px;
				left: 0px;
				right: 0px;
				height: 200px;
				margin-right: 0cm;
				width: 100%;
				color: #979A9A;
			}

			.footer-section {
				position:relative;
				height: 100%; width: 100%;
			}

			.footer-content {
				margin-top: 10px;
				background-color: transparent !important;
				position:relative;
				z-index: 9999999;
				height: 50px;
			}

			.onexdelivery-logo {
				font-size: 13px;
				font-weight: 400;
				line-height: 13.65px;
				letter-spacing: 0em;
				text-align: center;
				color: #1E1D20;
			}

			.domiciliary-table {
				width: 100%;
				padding-bottom: 10px;
			}

			.domiciliary-td {
				padding: 10px;
        		text-align: left;
                width: 33.33%;
			}

			.domiciliary-signature {
				font-size: 13px;
				font-weight: 600;
				line-height: 13.65px;
				letter-spacing: 0em;
				color: #1E1D20;
			}

			.domiciliary-name {
				font-size: 13px;
				font-weight: 600;
				line-height: 13.65px;
				letter-spacing: 0em;
				color: #1E1D20;
				margin-top: 50px;
				display: block;
				border-top: 1px solid #ECECEC;
				padding-top: 10px;
			}

			.domiciliaty-label {
				font-size: 13px;
				font-weight: 400;
				line-height: 13.65px;
				letter-spacing: 0em;
				text-align: left;
				color: #1E1D20;
			}

            .signature {
                padding-bottom: 20px;
            }

            .summary-table {
                width: 100%;
                margin-top: 2rem;
            }

            .summary-table td {
                vertical-align: top; /* Alinea el contenido en la parte superior */
                padding: 15px;
            }

            .summary-table .domiciliary-td {
                text-align: left; /* Alinea el texto a la izquierda */
            }

            .summary-table .domiciliary-signature {
                font-size: 16px;
                font-weight: 600;
                color: #1E1D20;
                display: block;
                margin-bottom: 1rem; /* Espacio debajo del encabezado */
            }

            .summary-table ul {
                list-style-type: none; /* Elimina los puntos de la lista */
                padding: 0;
                margin: 0;
            }

            .summary-table ul li {
                font-size: 14px;
                color: #1E1D20;
                margin-bottom: 0.5rem; /* Espacio entre elementos de la lista */
            }

            .summary-table .table-cant-text {
                font-size: 16px;
                font-weight: 600;
                color: #9747ff; /* Color destacado para los valores */
            }


		</style>
	</head>
	<body>
		<header>
			<div class="header-container">
				<div class="logo">
                    @if (!isset($configuration))
                        <img src="https://app.onexdelivery.com/img/onexdelivery/onex_icon_black.svg" alt="Logo">
                        @else
                        <img style="width: 100px;" src="{{ $configuration->logo }}" alt="Logo">
                    @endif
				</div>
				<div class="text">
					<strong>Reporte de cierre #{{$relation->id}}</strong>
				</div>
			</div>
		</header>
		<div class="card-container">
			<div class="card-content-domiciliary">
				<div class="card">
					<table>
						<tr>
							<td style="padding-right: 10px; padding-left: -5px">
								<div class="ico-card">
									<img src="./images/icons/icon_domiciliario.svg" alt="">
								</div>
							</td>
							<td>
								<div class="text-container">
									<p class="title-card">
										<strong> Domiciliario: </strong>
									</p>
									<p class="text-card">
										@if($relation->domiciliario and $relation->domiciliario->name)
											{{ $relation->domiciliario->name }}
										@else
										-
										@endif
									</p>
								</div>
							</td>
						</tr>
					</table>
				</div>
			</div>
			<div class="card-content">
				<div class="card">
					<table>
						<tr>
							<td style="padding-right: 10px;">
								<div class="ico-card">
									<img src="./images/icons/icon_calendario.svg" alt="">
								</div>
							</td>
							<td>
								<div class="text-container">
									<p class="title-card">
										<strong> Fecha: </strong>
									</p>
									<p class="text-card">
										{{ $relation->created_at->format('d/m/Y') }}
									</p>
								</div>
							</td>
						</tr>
					</table>
				</div>
			</div>
			<div class="card-content">
				<div class="card">
					<table>
						<tr>
							<td style="padding-right: 10px;">
								<div class="ico-card">
									<img src="./images/icons/icon_documentoID.svg" alt="">
								</div>
							</td>
							<td>
								<div class="text-container">
									<p class="title-card">
										<strong> Documento de identidad: </strong>
									</p>
									<p class="text-card">
										@if($relation->domiciliario and $relation->domiciliario->dni)
											{{ $relation->domiciliario->dni }}
										@else
										-
										@endif
									</p>
								</div>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</div>
		<main>
			<table class="table table-striped table-content">
				<thead>
					<tr class="tableS">
						<th>
							<p class="table-label">
								<b># Domicilio</b>
							</p>
						</th>
						<th>
							<p class="table-label">
								<b>Estatus</b>
							</p>
						</th>
                        <th>
							<p class="table-label">
								<b>Productos</b>
							</p>
						</th>
                        <th>
							<p class="table-label">
								<b>Recaudos</b>
							</p>
						</th>
						<th>
							<p class="table-label">
								<b>Total</b>
							</p>
						</th>
					</tr>
				</thead>
				@php
				$totalRecaudo = 0;
				@endphp
				<tbody>
					@foreach ($allItems as $key => $order)
						<tr style="position: relative">
							<td class="text-left; reference">
								<p class="table-text">
									{{ $order->reference }}
								</p>
							</td>
							<td class="text-left phone">
								<p class="table-text">
									{{ $order->status }}
								</p>
							</td>
                            <td class="text-left products">
                                <p class="table-text">
                                    @if(isset($order->content)
                                        && is_array(json_decode($order->content)))
                                        @php
                                            $products = json_decode($order->content);
                                        @endphp
                                        @if(count($products) > 0)
                                            <ul>
                                                @foreach($products as $product)
                                                    <li>{{ $product->name ?? '' }} ({{ $product->quantity ?? '' }})</li>
                                                @endforeach
                                            </ul>
                                        @endif
                                    @else
                                        {{$order->content}}
                                    @endif
                                </p>
                            </td>
                            <td class="text-left products">
                                <p class="table-text">
                                    <ul>
                                        @foreach($order->Collections as $recaudo)
                                            <li>{{ $recaudo->payment ?? '' }} ({{ $recaudo->value ?? '' }})</li>
                                        @endforeach
                                    </ul>
                                </p>
                            </td>
							<td class="text-center total">
								<p class="table-text">
								{{!is_null($configuration) ? $configuration->getCurrencySimbolAttribute() : '$'}}{{ number_format($order->total) }}
								</p>
							</td>
						</tr>
						@php
						$totalRecaudo += (float)$order->total;
						@endphp
					@endforeach
				</tbody>
			</table>

            <table class="summary-table domiciliary-table">
                <tr>
                    <!-- Columna 1: Resumen de pagos -->
                    <td class="domiciliary-td">
                        <span class="domiciliary-signature">
                            <b>Resumen de Pagos</b>
                        </span>
                        <ul>
                            @foreach ($paymentsSummary as $payment)
                                <li>
                                    {{ $payment['payment_method'] }}:
                                    <span>
                                        <strong>{{!is_null($configuration) ? $configuration->getCurrencySimbolAttribute() : '$'}}{{ number_format($payment['total'], 2) }} </strong>
                                    </span>
                                </li>
                            @endforeach
                        </ul>
                    </td>

                    <!-- Columna 2: Métricas de productos y pedidos -->
                        <td class="domiciliary-td">
                            <span class="domiciliary-signature">
                                <b>Métricas de Productos y Pedidos</b>
                            </span>
                            <ul>
                                <li>
                                    <strong>Productos entregados:</strong>
                                    <span>{{ $productsDelivered }}</span>
                                </li>
                                <li>
                                    <strong>Pedidos entregados:</strong>
                                    <span>{{ $itemsDelivered->count() ?? 0 }}</span>
                                </li>
                                <li>
                                    <strong>Productos no entregados:</strong>
                                    <span>{{ $productsNotDelivered }}</span>
                                </li>
                                <li>
                                    <strong>Pedidos no entregados:</strong>
                                    <span>{{ $itemsNotDelivered->count() ?? 0 }}</span>
                                </li>
                            </ul>
                        </td>
                </tr>
            </table>

		</main>
		<footer>
			<section class="footer-section">
				<div class="row footer-content">
					<table class="domiciliary-table">
						<tr>
							<td class="domiciliary-td">
								<center>
                                    <span class="domiciliary-signature">
                                        <b>FIRMA</b>
                                    </span>
                                    <span class="domiciliary-name signature">
                                        <b>Director de bodega</b>
                                    </span>
                                </center>
							</td>
							<td class="domiciliary-td">
								<center>
                                    <span class="domiciliary-signature">
                                        <b>FIRMA</b>
                                    </span>
                                    <span class="domiciliary-name signature">
                                        <b>Seguridad</b>
                                    </span>
                                </center>
							</td>
							<td class="domiciliary-td">
								<center>
                                    <span class="domiciliary-signature">
                                        <b>FIRMA</b>
                                    </span>
                                    @if($relation->domiciliario and $relation->domiciliario->name)
                                        <span class="domiciliary-name">
                                            <b>{{ $relation->domiciliario->name }}</b>
                                        </span>
                                    @else
                                    -
                                    @endif
                                    <span class="domiciliaty-label">
                                        Domiciliario
                                    </span>
                                </center>
							</td>
						</tr>
					</table>
					<p class="onexdelivery-logo" style="text-align:center;">
						&copy; {{ isset($configuration) ? $configuration->brand_name : 'OnexDelivery'  }} <?php echo date("Y"); ?>
						<p class="pagenum" style="color: #838383 !important;">
							<script type="text/php">
								if ( isset($pdf) ) {
									$pdf->page_script('
										$font = $fontMetrics->get_font("Arial, Helvetica, sans-serif", "normal");
										$pdf->text(490, 777, "Pág. $PAGE_NUM de $PAGE_COUNT", $font, 10);
									');
								}
							</script>
						</p>
					</p>
				</div>
			</section>
		</footer>
	</body>
</html>