<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>Relacion de despacho # <?php echo e($relation->id); ?></title>
    <style>
        /** Define the margins of your page **/
        @page  {
            margin: 1cm;
        }

        body {
            min-width: 100px;
            min-height: 100%;
            font-family: "Roboto", "-apple-system", "Helvetica Neue", Helvetica, Arial, sans-serif !important;
            -ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            font-smoothing: antialiased;
            line-height: 1.5;
            font-size: 14px;
            color: #333;
            background-color: #fff;
        }

        header {
            position: relative;
            background: #EBEDEF;
            margin-top: -1cm;
            margin-left: -40px;
            width: 120%;
            height: 180px;
        }

        main {
            margin-top: 0;
            margin-bottom: 1.5cm;
            position: relative;
        }

        footer {
            position: fixed;
            bottom: 10px;
            left: 0px;
            right: 0px;
            height: 80px;
            margin-right: 0cm;
            width: 100%;

            /** Extra personal styles **/
            color: #979A9A;
        }

        table {
            border-spacing: 0;
            border-collapse: collapse;
            background-color: transparent;

        }


        td,
        th {
            padding: 0;
        }

        th {
            text-align: left;
        }


        .table {
            width: 100%;
            max-width: 100%;
            margin-bottom: 20px;
        }

        .table>thead>tr>th,
        .table>tbody>tr>th,
        .table>tfoot>tr>th,
        .table>thead>tr>td,
        .table>tbody>tr>td,
        .table>tfoot>tr>td {
            padding: 6px;
            line-height: 1.02857143;
            vertical-align: top;

        }

        .table>thead>tr>th {
            vertical-align: bottom;

        }

        .table>caption+thead>tr:first-child>th,
        .table>colgroup+thead>tr:first-child>th,
        .table>thead:first-child>tr:first-child>th,
        .table>caption+thead>tr:first-child>td,
        .table>colgroup+thead>tr:first-child>td,
        .table>thead:first-child>tr:first-child>td {
            border-top: 0;
        }

        .table>tbody+tbody {}

        .table .table {
            background-color: #fff;
        }

        .table-condensed>thead>tr>th,
        .table-condensed>tbody>tr>th,
        .table-condensed>tfoot>tr>th,
        .table-condensed>thead>tr>td,
        .table-condensed>tbody>tr>td,
        .table-condensed>tfoot>tr>td {
            padding: 5px;
        }

        .table-bordered {
            border: 1px solid #ddd;
        }

        .table-bordered>thead>tr>th,
        .table-bordered>tbody>tr>th,
        .table-bordered>tfoot>tr>th,
        .table-bordered>thead>tr>td,
        .table-bordered>tbody>tr>td,
        .table-bordered>tfoot>tr>td {
            border: 1px solid #ddd;
        }

        .table-bordered>thead>tr>th,
        .table-bordered>thead>tr>td {
            border-bottom-width: 2px;
        }

        .table-striped>tbody>tr:nth-of-type(odd) {
            background-color: #F0F1F7;
            border-radius: 10px
        }

        .table-hover>tbody>tr:hover {
            background-color: #f5f5f5;
        }

        table col[class*="col-"] {
            position: static;
            display: table-column;
            float: none;
        }

        table td[class*="col-"],
        table th[class*="col-"] {
            position: static;
            display: table-cell;
            float: none;
        }

        .table>thead>tr>td.active,
        .table>tbody>tr>td.active,
        .table>tfoot>tr>td.active,
        .table>thead>tr>th.active,
        .table>tbody>tr>th.active,
        .table>tfoot>tr>th.active,
        .table>thead>tr.active>td,
        .table>tbody>tr.active>td,
        .table>tfoot>tr.active>td,
        .table>thead>tr.active>th,
        .table>tbody>tr.active>th,
        .table>tfoot>tr.active>th {
            background-color: #f5f5f5;
        }

        .table-hover>tbody>tr>td.active:hover,
        .table-hover>tbody>tr>th.active:hover,
        .table-hover>tbody>tr.active:hover>td,
        .table-hover>tbody>tr:hover>.active,
        .table-hover>tbody>tr.active:hover>th {
            background-color: #e8e8e8;
        }

        .table>thead>tr>td.success,
        .table>tbody>tr>td.success,
        .table>tfoot>tr>td.success,
        .table>thead>tr>th.success,
        .table>tbody>tr>th.success,
        .table>tfoot>tr>th.success,
        .table>thead>tr.success>td,
        .table>tbody>tr.success>td,
        .table>tfoot>tr.success>td,
        .table>thead>tr.success>th,
        .table>tbody>tr.success>th,
        .table>tfoot>tr.success>th {
            background-color: #dff0d8;
        }

        .table-hover>tbody>tr>td.success:hover,
        .table-hover>tbody>tr>th.success:hover,
        .table-hover>tbody>tr.success:hover>td,
        .table-hover>tbody>tr:hover>.success,
        .table-hover>tbody>tr.success:hover>th {
            background-color: #d0e9c6;
        }

        .table>thead>tr>td.info,
        .table>tbody>tr>td.info,
        .table>tfoot>tr>td.info,
        .table>thead>tr>th.info,
        .table>tbody>tr>th.info,
        .table>tfoot>tr>th.info,
        .table>thead>tr.info>td,
        .table>tbody>tr.info>td,
        .table>tfoot>tr.info>td,
        .table>thead>tr.info>th,
        .table>tbody>tr.info>th,
        .table>tfoot>tr.info>th {
            background-color: #d9edf7;
        }

        .table-hover>tbody>tr>td.info:hover,
        .table-hover>tbody>tr>th.info:hover,
        .table-hover>tbody>tr.info:hover>td,
        .table-hover>tbody>tr:hover>.info,
        .table-hover>tbody>tr.info:hover>th {
            background-color: #c4e3f3;
        }

        .table>thead>tr>td.warning,
        .table>tbody>tr>td.warning,
        .table>tfoot>tr>td.warning,
        .table>thead>tr>th.warning,
        .table>tbody>tr>th.warning,
        .table>tfoot>tr>th.warning,
        .table>thead>tr.warning>td,
        .table>tbody>tr.warning>td,
        .table>tfoot>tr.warning>td,
        .table>thead>tr.warning>th,
        .table>tbody>tr.warning>th,
        .table>tfoot>tr.warning>th {
            background-color: #fcf8e3;
        }

        .table-hover>tbody>tr>td.warning:hover,
        .table-hover>tbody>tr>th.warning:hover,
        .table-hover>tbody>tr.warning:hover>td,
        .table-hover>tbody>tr:hover>.warning,
        .table-hover>tbody>tr.warning:hover>th {
            background-color: #faf2cc;
        }

        .table>thead>tr>td.danger,
        .table>tbody>tr>td.danger,
        .table>tfoot>tr>td.danger,
        .table>thead>tr>th.danger,
        .table>tbody>tr>th.danger,
        .table>tfoot>tr>th.danger,
        .table>thead>tr.danger>td,
        .table>tbody>tr.danger>td,
        .table>tfoot>tr.danger>td,
        .table>thead>tr.danger>th,
        .table>tbody>tr.danger>th,
        .table>tfoot>tr.danger>th {
            background-color: #f2dede;
        }

        .table-hover>tbody>tr>td.danger:hover,
        .table-hover>tbody>tr>th.danger:hover,
        .table-hover>tbody>tr.danger:hover>td,
        .table-hover>tbody>tr:hover>.danger,
        .table-hover>tbody>tr.danger:hover>th {
            background-color: #ebcccc;
        }

        .collapse {
            display: none;
        }

        .collapse.in {
            display: block;
        }

        tr.collapse.in {
            display: table-row;
        }

        tbody.collapse.in {
            display: table-row-group;
        }

        @media  print {

            *,
            *:before,
            *:after {
                color: #000 !important;
                text-shadow: none !important;
                background: transparent !important;
                -webkit-box-shadow: none !important;
                box-shadow: none !important;
            }

            a,
            a:visited {
                text-decoration: underline;
            }

            a[href]:after {
                content: " ("attr(href) ")";
            }

            abbr[title]:after {
                content: " ("attr(title) ")";
            }

            a[href^="#"]:after,
            a[href^="javascript:"]:after {
                content: "";
            }

            pre,
            blockquote {
                border: 1px solid #999;

                page-break-inside: avoid;
            }

            thead {
                display: table-header-group;
            }

            tr,
            img {
                page-break-inside: avoid;
            }

            img {
                max-width: 100% !important;
            }

            p,
            h2,
            h3 {
                orphans: 3;
                widows: 3;
            }

            h2,
            h3 {
                page-break-after: avoid;
            }

            .navbar {
                display: none;
            }

            .btn>.caret,
            .dropup>.btn>.caret {
                border-top-color: #000 !important;
            }

            .label {
                border: 1px solid #000;
            }

            .table {
                border-collapse: collapse !important;
            }

            .table td,
            .table th {
                background-color: #fff !important;
            }

            .table-bordered th,
            .table-bordered td {
                border: 1px solid #ddd !important;
            }
        }

        .row {
            width: 100%
        }

        .col-xs-1,
        .col-sm-1,
        .col-md-1,
        .col-lg-1,
        .col-xs-2,
        .col-sm-2,
        .col-md-2,
        .col-lg-2,
        .col-xs-3,
        .col-sm-3,
        .col-md-3,
        .col-lg-3,
        .col-xs-4,
        .col-sm-4,
        .col-md-4,
        .col-lg-4,
        .col-xs-5,
        .col-sm-5,
        .col-md-5,
        .col-lg-5,
        .col-xs-6,
        .col-sm-6,
        .col-md-6,
        .col-lg-6,
        .col-xs-7,
        .col-sm-7,
        .col-md-7,
        .col-lg-7,
        .col-xs-8,
        .col-sm-8,
        .col-md-8,
        .col-lg-8,
        .col-xs-9,
        .col-sm-9,
        .col-md-9,
        .col-lg-9,
        .col-xs-10,
        .col-sm-10,
        .col-md-10,
        .col-lg-10,
        .col-xs-11,
        .col-sm-11,
        .col-md-11,
        .col-lg-11,
        .col-xs-12,
        .col-sm-12,
        .col-md-12,
        .col-lg-12 {
            position: relative;
            min-height: 1px;
            padding-right: 15px;
            padding-left: 15px;
        }

        .col-xs-1,
        .col-xs-2,
        .col-xs-3,
        .col-xs-4,
        .col-xs-5,
        .col-xs-6,
        .col-xs-7,
        .col-xs-8,
        .col-xs-9,
        .col-xs-10,
        .col-xs-11,
        .col-xs-12 {
            float: left;
        }

        .col-xs-12 {
            width: 100%;
        }

        .col-xs-11 {
            width: 91.66666667%;
        }

        .col-xs-10 {
            width: 83.33333333%;
        }

        .col-xs-9 {
            width: 75%;
        }

        .col-xs-8 {
            width: 66.66666667%;
        }

        .col-xs-7 {
            width: 58.33333333%;
        }

        .col-xs-6 {
            width: 50%;
        }

        .col-xs-5 {
            width: 41.66666667%;
        }

        .col-xs-4 {
            width: 33.33333333%;
        }

        .col-xs-3 {
            width: 25%;
        }

        .col-xs-2 {
            width: 16.66666667%;
        }

        .col-xs-1 {
            width: 8.33333333%;
        }

        .col-xs-pull-12 {
            right: 100%;
        }

        .col-xs-pull-11 {
            right: 91.66666667%;
        }

        .col-xs-pull-10 {
            right: 83.33333333%;
        }

        .col-xs-pull-9 {
            right: 75%;
        }

        .col-xs-pull-8 {
            right: 66.66666667%;
        }

        .col-xs-pull-7 {
            right: 58.33333333%;
        }

        .col-xs-pull-6 {
            right: 50%;
        }

        .col-xs-pull-5 {
            right: 41.66666667%;
        }

        .col-xs-pull-4 {
            right: 33.33333333%;
        }

        .col-xs-pull-3 {
            right: 25%;
        }

        .col-xs-pull-2 {
            right: 16.66666667%;
        }

        .col-xs-pull-1 {
            right: 8.33333333%;
        }

        .col-xs-pull-0 {
            right: auto;
        }

        .col-xs-push-12 {
            left: 100%;
        }

        .col-xs-push-11 {
            left: 91.66666667%;
        }

        .col-xs-push-10 {
            left: 83.33333333%;
        }

        .col-xs-push-9 {
            left: 75%;
        }

        .col-xs-push-8 {
            left: 66.66666667%;
        }

        .col-xs-push-7 {
            left: 58.33333333%;
        }

        .col-xs-push-6 {
            left: 50%;
        }

        .col-xs-push-5 {
            left: 41.66666667%;
        }

        .col-xs-push-4 {
            left: 33.33333333%;
        }

        .col-xs-push-3 {
            left: 25%;
        }

        .col-xs-push-2 {
            left: 16.66666667%;
        }

        .col-xs-push-1 {
            left: 8.33333333%;
        }

        .col-xs-push-0 {
            left: auto;
        }

        .col-xs-offset-12 {
            margin-left: 100%;
        }

        .col-xs-offset-11 {
            margin-left: 91.66666667%;
        }

        .col-xs-offset-10 {
            margin-left: 83.33333333%;
        }

        .col-xs-offset-9 {
            margin-left: 75%;
        }

        .col-xs-offset-8 {
            margin-left: 66.66666667%;
        }

        .col-xs-offset-7 {
            margin-left: 58.33333333%;
        }

        .col-xs-offset-6 {
            margin-left: 50%;
        }

        .col-xs-offset-5 {
            margin-left: 41.66666667%;
        }

        .col-xs-offset-4 {
            margin-left: 33.33333333%;
        }

        .col-xs-offset-3 {
            margin-left: 25%;
        }

        .col-xs-offset-2 {
            margin-left: 16.66666667%;
        }

        .col-xs-offset-1 {
            margin-left: 8.33333333%;
        }

        .col-xs-offset-0 {
            margin-left: 0;
        }

        .pagenum:before {

            margin-left: 6cm;
        }

        .totals {
            position: absolute;
            right: 0px;
            top: -200px;
            width: 100%;
        }

        .card-total {
            width: 23%;
            border: 1px solid #6532ba;
            border-radius: 10px;
            height: 70px;
            display: inline-block;
            background: #E0D6F1 !important;
            margin-top: 20px;
        }
        .card-total-header {
            height: 20px;
            width: 94.3%;
            background: #F0F1F7;
            padding-left: 9px;
            padding-bottom: 3px;
            color: #292929;
            font-size: 10pt;
            border-radius: 10px 10px 0px 0px;
            margin-top: -13px !important;
        }
        .card-total-body {
            height: 30px !important;
            background: #E0D6F1;
            border-radius: 0px 0px 10px 10px;
            color: #6532ba;
            width: 100%;
            display: inline-block;
        }
        .card-number-total {
          background: #6532ba;
          color: white;
          width: 30px;
          height: 39px;
          border-radius: 0px 0px 0px 10px;
          position: relative;
          display: flex;
          align-items: center;
          justify-content: center;
          padding-top: 8px !important;
          padding-left: 15px !important;
        }
        .card-total-amount {
          text-align: center;
          height: 30px;
          width: 70%;
          overflow: hidden;
          margin-left: 46px;
          margin-top: -39px;
        }
        .total-no-count {
          height: 30px;
          width: 100%;
          margin-top: 8px;
          text-align: center;
        }
        .page-break {
            page-break-before: always;
        }
    </style>
</head>

<body>
    <!-- Define header and footer blocks before your content -->
    <header>
        <div class="row">
            <div class="col-xs-1" style="margin-top: 5%; margin-left: -2% !important ">
            <img src="https://onexdelivery.agri-techsolutions.com/icon.png" style="width: 60px; border-radius: 0; margin-left: 45px;">
              </div>
            <div class="col-xs-3" style="margin-top: 12%; ">
                <p style="font-weight: 600; margin-top: 8pt; margin-left: -3.5rem; font-size: 15pt; line-height: 2rem; letter-spacing: normal; color:#6532ba; position:absolute;">
                    <strong> Relación de despacho N° <?php echo e($relation->id); ?> </strong>
                </p>
            </div>
            <div class="col-xs-4" style="margin-top: 4%; padding-left: 2.5rem">
                <p style="color:#292929; font-size: 10pt"><strong> Fecha: </strong></p>
                <p style="color:#292929; font-size: 10pt; margin-top: -11px">
                    <?php echo e($relation->created_at->format('d/m/Y')); ?>

                </p>
                <p style="color:#292929; font-size: 10pt; margin-top: 0px;"><strong> Domiciliario: </strong></p>
                <p style="color:#292929; font-size: 10pt; margin-top: -11px">
                    <?php if($relation->domiciliario and $relation->domiciliario->name): ?>
                        <?php echo e($relation->domiciliario->name); ?>

                        <?php else: ?>
                        -
                    <?php endif; ?>
                </p>
            </div>
            <div class="col-xs-3" style="margin-top: 10.4%; margin-left: -3.6rem ">
                <p style="color:#292929; font-size: 10pt"><strong> Cédula de identidad: </strong></p>
                <p style="color:#292929; font-size: 10pt; margin-top: -5px; line-height: 14px">
                    <?php if($relation->domiciliario and $relation->domiciliario->dni): ?>
                        <?php echo e($relation->domiciliario->dni); ?>

                        <?php else: ?>
                        -
                    <?php endif; ?>
                </p>
            </div>
        </div>
    </header>
    <main>
        <table class="table table-striped" style="margin-top: 1.5rem; margin-left: 0px">
            <thead>
                <tr class="tableS">
                    <th>
                        <p style="font-size: 10pt !important; font-weight: 300 !important; color: #292929; padding-left: 10px" class="font-11 text-center"><b># Domicilio</b></p>
                    </th>
                    <th>
                        <p style="font-size: 10pt !important; font-weight: 300 !important; color: #292929; padding-left: 20px" class="font-11 text-center"><b>Cliente</b></p>
                    </th>
                    <th>
                        <p style="font-size: 10pt !important; font-weight: 300 !important; color: #292929; padding-left: 20px" class="font-11 text-center"><b>Tel.</b></p>
                    </th>
                    <th>
                        <p style="font-size: 10pt !important; font-weight: 300 !important; color: #292929; padding-left: 20px" class="font-11 text-center"><b>Dirección</b></p>
                    </th>
                    <th>
                        <p style="font-size: 10pt !important; font-weight: 300 !important; color: #292929; padding-left: 20px" class="font-11 text-center"><b>Detalles</b></p>
                    </th>
                    <th>
                        <p style="font-size: 10pt !important; font-weight: 300 !important; color: #292929; padding-left: 20px" class="font-11 text-center"><b>Total</b></p>
                    </th>
                </tr>
            </thead>
            <?php
            $totalRecaudo = 0;
            ?>
            <tbody>
                <?php $__currentLoopData = $relation->dispatchRelationItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr style="position: relative">
                        <td class="text-left" style="border-radius: 10px 0px 0px 10px;position: relative">
                            <div style="positon: absolute; margin-left: -10px; margin-top: 10px; color: 292929; font-size: 8pt; padding-left: 20px">
                                #<?php echo e($key + 1); ?>

                            </div>
                            <p class="text-left" style="color: 292929; font-size: 8pt; padding-left: 30px; margin-top: -11px">
                                <?php echo e($order->domicilio->reference); ?>

                            </p>
                        </td>
                        <td class="text-left">
                            <p class="text-left" style="color: 292929; font-size: 8pt; padding-left: 20px">
                                <?php echo e($order->domicilio->Client->name); ?>

                            </p>
                        </td>
                        <td class="text-left">
                            <p class="text-left" style="color: 292929; font-size: 8pt; padding-left: 20px">
                                <?php echo e($order->domicilio->Client->phone); ?>

                            </p>
                        </td>
                        <td class="text-left">
                            <p class="text-left" style="color: 292929; font-size: 8pt; padding-left: 20px">
                                <?php echo e($order->domicilio->Client->address); ?>

                            </p>
                        </td>
                        <td class="text-center">
                            <p class="text-center" style="color: 292929; font-size: 8pt; padding-left: 20px">
                                <?php if($order->domicilio->observation): ?>
                                    <?php echo e($order->domicilio->observation); ?>

                                <?php endif; ?>
                            </p>
                        </td>
                        <td class="text-center" style="border-radius: 0px 10px 10px 0px; padding-right: 22px !important">
                            <p class="text-center" style="color: 292929; font-size: 8pt; padding-left: 20px">
                                $<?php echo e(number_format($order->domicilio->total)); ?>

                            </p>
                        </td>
                    </tr>
                    <?php
                        $totalRecaudo += (float)$order->domicilio->total;
                    ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <div style="width: 100%; height: 30px">
            <p class="font-10" style="text-align: ; color: 292929; font-size: 10pt; ">
                <span style="float: left"><strong>Cantidad: </strong>: <?php echo e(count($relation->dispatchRelationItems)); ?></span>
                <span style="float: right"><strong>Total</strong>: <?php echo e(number_format($totalRecaudo)); ?></span>
            </p>
        </div>
    </main>
    <footer>
        <section style="position:relative; height: 100%; width: 100%">
            <div class="row" style="margin-top: 10px; background-color: transparent !important; position:relative; z-index: 9999999; height: 50px">
                <p style="text-align:center;">
                &copy; OnexDelivery <?php echo date("Y"); ?>
                    <p class="pagenum" style="color: #838383 !important;">
                        <script type="text/php">
                            if ( isset($pdf) ) {
                                $pdf->page_script('
                                    $font = $fontMetrics->get_font("Arial, Helvetica, sans-serif", "normal");
                                    $pdf->text(490, 777, "Pág. $PAGE_NUM de $PAGE_COUNT", $font, 10);
                                ');
                            }
                        </script>
                    </p>
                </p>
            </div>
        </section>
    </footer>
</body>
</html>
<?php /**PATH C:\laragon\www\onex-delivery\resources\views/luxury/relation.blade.php ENDPATH**/ ?>