<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use App\Domicilio;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model
{
    use SoftDeletes;
    // fillable
    protected $fillable = [
        'name',
        'user_id',
        'dni',
        'phone',
        'email',
        'address',
        'getho',
        'address_note',
        'zone_id',
        'city_id'
    ];

    protected $appends = [
        'city_name',
        'zone_name'
    ];

    // relaciones
    public function Domicilios() {
        return $this->hasMany('App\Domicilio');
    }

    public function Zone() {
        return $this->belongsTo('App\Zone');
    }

    public function City() {
        return $this->belongsTo('App\City');
    }

    // scopes
    public function scopeDesc($query) {
        return $query->orderBy('id', 'DESC');
    }

    public function scopeAsc($query) {
        return $query->orderBy('id', 'ASC');
    }

    public function scopeUserId($query, $id) {
        return $query->where('user_id', $id);
    }

    public function scopeEmail($query, $email) {
        return $query->where('email', $email);
    }

    public function scopeDni($query, $dni) {
        return $query->where('dni', $dni);
    }

    public function scopePhone($query, $phone) {
        return $query->where('phone', $phone);
    }

    static function scopeValidate($query, $dni, $id) {
       return $query->Dni($dni)->UserId($id);
    }

    //hook
    static function getClientData($dni, $mainId) {
        $client = Client::where('dni', '=', $dni)
        ->first();
        if (isset($client->id)) {
            return $client;
        }
    }

    static function getAllPedidos($dni) {
        $orders = Domicilio::where('dni', '=', $dni)
        ->get();
        return $orders;
    }

    //helper function
    public function getDni() {
        $dni = explode('-', $this->dni);
        return $dni[0];
    }

    public function getDv() {
        $dni = explode('-', $this->dni);
        return $dni[1];
    }

    // attributes appends
    public function getCityNameAttribute() {
        if (isset($this->City)) {
            return $this->City->name;
        }
        return '';
    }

    public function getZoneNameAttribute() {
        if (isset($this->Zone)) {
            return $this->Zone->name;
        }
        return '';
    }
}
