<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\Parameters\ParameterService;
use App\Helpers\Helper;
use App\Parameter;
use App\Http\Requests\Parameters\ParameterRequest;
use App\Http\Requests\Parameters\UpdateParameterRequest;

class ParameterController extends Controller
{
    protected $parameterService;

    public function __construct(ParameterService $parameterService)
    {
        $this->parameterService = $parameterService;
    }

    public function index(Request $request)
    {
        try {
            $perPage = $request->perPage ? $request->perPage : 10;
            $search = $request->search ? $request->search : '';

            return $this->parameterService->getAllParametersPaginated($perPage, $search);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function getAllList()
    {
        try {
            return $this->parameterService->getAllParameters();
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function store(ParameterRequest $request)
    {
        try {
            $data = $request->only(['name', 'type', 'value', 'description']);
            $parameter = $this->parameterService->create($data);
            return Helper::response(
                'success',
                [
                    'meesage' => 'Se ha registrado el parámetro',
                    'parameter' => $parameter
                ],
                201
            );
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function show(Parameter $parameter)
    {
        try {
            return Helper::response('success', $parameter, 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function update(UpdateParameterRequest $request, Parameter $parameter)
    {
        try {
            $data = $request->only(['name', 'type', 'value', 'description']);
            $this->parameterService->update($parameter, $data);
            return Helper::response('success', 'Se ha editado el parámetro', 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function destroy(Parameter $parameter)
    {
        try {
            $parameter->delete();
            return Helper::response('success', 'Se ha eliminado el parámetro', 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }
}
