<?php

namespace App\Http\Requests\Domiciliario;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PostRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */

    public function rules()
    {
        return [
            'name' => 'required|min:3|max:50|regex:/^[A-Za-zÁÉÍÓÚÜáéíóúüñÑ\s]+$/',
            'email' => 'required|email|unique:domiciliarios,email',
            'dni' => 'required|min:8|max:15|unique:domiciliarios,dni',
            'phone' => 'required|max:15',
            'password' => 'required|min:8|max:12|regex:/(?=.*\d)(?=.*[a-z])(?=.*[A-Z])/',
            'hiring_method' => 'required',
            'plate' => 'required|max:10',
            'file' => 'required|image|mimes:jpg,png|max:2048', // Regla para la imagen
            'city' => 'required|numeric',
        ];
    }

    public function messages()
    {
        return [
            'name.required' => 'Campo nombre requerido.',
            'name.min' => 'El nombre no debe tener menos de 3 caracteres.',
            'name.max' => 'El nombre no debe tener más de 50 caracteres.',
            'name.regex' => 'El nombre debe contener solo letras y espacios.',
            'email.required' => 'El campo correo electrónico es obligatorio.',
            'email.email' => 'Correo electrónico no válido.',
            'email.unique' => 'El correo electrónico ingresado ya está en uso.',
            'dni.required' => 'El campo DNI es obligatorio.',
            'dni.unique' => 'El DNI ingresado ya está en uso.',
            'dni.max' => 'El DNI no debe tener más de 15 caracteres.',
            'phone.required' => 'Campo teléfono requerido.',
            'phone.max' => 'Número de teléfono no válido. Debe tener máximo 15 dígitos.',
            'password.required' => 'Campo contraseña requerido.',
            'password.min' => 'La contraseña no debe tener menos de 8 caracteres.',
            'password.max' => 'La contraseña no debe tener más de 12 caracteres.',
            'password.regex' => 'La contraseña debe contener al menos una letra mayúscula, una letra minúscula y un número.',
            'hiring_method.required' => 'Campo método de contratación requerido.',
            'file.image' => 'El archivo debe ser una imagen.',
            'file.mimes' => 'El archivo debe estar en formato JPG o PNG.',
            'file.max' => 'El archivo no debe pesar más de 2 MB.',
            'plate.required' => 'La placa del vehiculo es requerida',
            'plate.max' => 'La placa del vehiculo. Debe tener máximo 10 dígitos.',
            'city.required' => "La ciudad donde opera el domiciliario es requerida",
            'city.numeric' => "La ciudad debe ser un número",

        ];
    }
}
