<?php

namespace App\Http\Requests\Domicilio;


use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class DomicilioRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            //
            'log_sender_id' => 'required|numeric|exists:log_senders,id',
            'type' => 'required|in:Express,Delivery',
            // 'domiciliario_id' => [
            //     //'numeric',
            //     'exists:domiciliarios,id',
            //     // Rule::requiredIf(function () {
            //     //     return Auth::user()->role_id != 4;
            //     // }),
            // ],
            'delivery' => 'required',
            //'payment_method_id' => 'required|numeric|exists:payment_methods,id',
            'client' => 'required',
            //'client.id' => 'numeric|exists:clients,id',
            'client.name' => 'required',
            'client.address' => 'required',
            'client.phone' => 'required',
            //'client.dni' => 'required',
            'client.city_id' => [
                Rule::requiredIf(function () {
                    return Auth::user()->role_id != 4;
                }),
                'exists:cities,id',
            ],
            'client.zone_id' => [
                'exists:zones,id',
                Rule::requiredIf(function () {
                    if (!is_null($this->zone_id)) {
                        return Auth::user()->role_id != 4;
                    } else {
                        return false;
                    }
                }),
            ],
            // 'products' => 'required',
            // 'products.*.name' => 'required|string',
            // 'products.*.quantity' => 'required|numeric',
        ];
    }

    public function messages()
    {
        return [
            // 'products.required' => 'Debes especificar los paquetes enviados.',
            // 'products.*.name.required' => 'Debes especificar el nombre del paquete.',
            // 'products.*.name.string' => 'El nombre del paquete debe ser un string.',
            // 'products.*.quantity.required' => 'Debes especificar la cantidad en el paquete.',
            // 'products.*.quantity.numeric' => 'La cantidad en el paquete debe ser un numero.',
            'delivery.required' => 'Debes especificar el costo del envio.',
            'client.id.exists' => 'El cliente id debe ser un id registrado en nuestra base de datos.',
            //'client.id.numeric' => 'El cliente id debe ser numerico.',
            // 'payment_method_id.required' => 'Debes seleccionar un metodo de pago.',
            // 'payment_method_id.numeric' => 'El metodo de pago debe ser numerico.',
            // 'payment_method_id.exists' => 'El metodo de pago debe ser un id registrado en nuestra base de datos.',
            //'domiciliario_id.numeric' => 'El domiciliario id debe ser numerico.',
            //'domiciliario_id.exists' => 'El domiciliario id debe ser un id registrado en nuestra base de datos.',
            'log_sender_id.required' => 'Debes seleccionar un remitente.',
            'log_sender_id.numeric' => 'El remitente id debe ser numerico.',
            'log_sender_id.exists' => 'El remitente id debe ser un id registrado en nuestra base de datos.',
            'type.required' => 'Debes seleccionar un tipo domicilio.',
            'client.required' => 'Debes ingresar un cliente.',
            'client.name.required' => 'Debes ingresar el nombre del cliente.',
            'client.phone.required' => 'Debes ingresar el teléfono del cliente.',
            'client.address.required' => 'Debes ingresar la dirección del cliente.',
            'type.in' => 'El tipo de domicilio solo puede ser Express o Delivery.',
            'aditional_payment.required' => 'El campo pago adicional debe ser mayor o igual a 0.',
            //'client.dni.required' => 'Debes ingresar la cédula del cliente.',
            'client.city_id.required' => 'Debes ingresar la ciudad del cliente.',
            'client.city_id.exists' => 'La ciudad del cliente debe estar registrada en nuestros sistemas.',
            'client.zone_id.required' => 'Debes ingresar la zona del cliente.',
            'client.zone_id.exists' => 'La zona del cliente debe estar registrada en nuestros sistemas.',
        ];
    }
}
