<?php

namespace App\Http\Requests\Rescheduling;

use Illuminate\Foundation\Http\FormRequest;

class StoreReschedulingRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'domicilio_id' => 'required|numeric',
            'date' => 'required|date',
            'startTime' => ['required', 'regex:/^(2[0-3]|[01]?[0-9]):[0-5][0-9]$/'],
            'endTime' => ['required', 'regex:/^(2[0-3]|[01]?[0-9]):[0-5][0-9]$/'],
            'description' => 'required|max:100|min:5',
            'file' => 'image|max:10000'
        ];
    }

    public function messages()
    {
        return [
            "domicilio_id.required" => "El domicilio es requerido",
            "domicilio_id.numeric" => "El id del domicilio debe ser numérico",
            "date.required" => "La fecha de reprogramación es requerida",
            "date.date" => "La fecha de reprogramación debe tener un formato válido",
            "startTime.required" => "La hora inicial es requerida",
            "startTime.regex" => "La hora inicial debe tener un formato válido (HH:MM)",
            "endTime.required" => "La hora final es requerida",
            "endTime.regex" => "La hora final debe tener un formato válido (HH:MM)",
            "description.required" => "La descripción es requerida",
            "description.max" => "La descripción no puede superar los 100 caracteres",
            "description.min" => "La descripción debe tener al menos 5 caracteres",
            "file.image" => "El archivo debe ser una imagen",
            "file.max" => "La imagen no puede ser mayor de 10MB"
        ];
    }
}
