<?php

namespace App\Http\Requests\Zone;

use App\Rules\UniqueByZone;
use Illuminate\Foundation\Http\FormRequest;

class UpdateZoneRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            //
            'name' => 'required|max:60',
            'code' => [
                'required',
                'max:15',
                new UniqueByZone
            ]
        ];
    }
}
