<?php

namespace App\Http\Requests\Zone;

use Illuminate\Foundation\Http\FormRequest;

class ZoneRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = $this->id ?? '';
        return [
            //
            'code' => 'required|max:15',
            'name' => 'required|max:60|unique:zones,name,except,' . $id,
            'city_id' => 'required|exists:cities,id',
            'value' => 'nullable|numeric',
            'finally_price' => 'nullable|numeric'
        ];
    }

    /**
     * messages
     */
    public function messages() {
        return [
            'code.required' => 'El código de la zona es requerido.',
            'code.max' => 'El código de la zona debe tener máximo 15 caracteres.',
            'code.unique' => 'El código de la zona se encuentra en uso.',
            'name.required' => 'El nombre de la zona es requerido.',
            'name.max' => 'El nombre de la zona debe tener máximo 60 caracteres.',
            'name.unique' => 'El nombre de la zona se encuentra en uso.',
            'city_id.required' => 'La ciudad de la zona es requerida.',
            'city_id.exists' => 'La ciudad debe existir en nuestros registros.'
        ];
    }
}
