<?php

namespace App\Http\Resources\Domicilio;

use Illuminate\Http\Resources\Json\ResourceCollection;
use App\Http\Resources\Domiciliario\DomiciliarioResource;
use App\Http\Resources\DomicilioProduct\DomicilioProductsCollection;
use App\Http\Resources\Status\StatusCollection;
use App\Http\Resources\Seller\SellerResource;

use Carbon\Carbon;

class FreezingCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            if ($models->guide) {
                $has_guide = $models->guide->count() > 0 ? true : false;
            }
            if ($models->TypePayments){
                $paymetsName = '';
                foreach ($models->TypePayments as $value) {
                    $paymetsName .= $value->name." ";
                }
             }

            return [
                'id' => $models->id,
                'reference' => $models->reference,
                'channel' => $models->channel,
                'client_id' => $models->client_id,
                'observation'  => $models->observation,
                'price'  => $models->price,
                'taxt'  => $models->taxt,
                'discountTotal'  => $models->discount,
                'discount'  => $models->discount_porcent,
                'utilities'  => $models->utilities,
                'delivery'  => $models->delivery,
                'total'  => $models->total,
                'status'  => $models->approve ? 'Liquidado' : 'Congelado',
                'purse' => ($models->total - $models->total_payment),
                'load_web'  => $models->load_web ? true : false,
                'is_pay'  => $models->is_pay,
                'name'  => $models->Client ? $models->Client->name : 'No posee',
                'credit'  => $models->is_credit ? 'Si' : 'No',
                'phone'  => $models->Client ? $models->Client->phone : 'No posee',
                'liquidad'  => $models->is_liquidado,
                'garantia'  => $models->is_warranty,
                'seller_id'  => new SellerResource($models->Seller),
                'hora'  => $models->created_at->format('d-m-Y'),
                'is_credit'  => $models->is_credit,
                'icg_client'  => $models->icg_client,
                'icg_document_id'  => $models->icg_document_id,
                'type'  => $models->type,
                'type_payment'  => $models->TypePayments,
                'tPayment'  => $models->TypePayments ? $paymetsName : '-',
                'method_payment'  => $models->method_payment,
                'guides' => $models->guide,
                'domiciliario' => $models->domiciliario ? $models->domiciliario->name : 'Sin-domiciliario',
                'domiciliario_id' => $models->domiciliario_id,
                'date_pay' => $models->date_pay,
                'date' => $models->created_at->format('d-m-Y'),
                'approve' => $models->approve ? true : false,
                'guide_sender' => $models->guide ? $models->guide->sender : null,
                'guide_payment_method' => $models->guide ? $models->guide->paymentMethod : null,
                'has_guide' => @$has_guide
            ];
        });
    }
}
